/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.pathfinding;

import com.badlogic.gdx.ai.pfa.GraphPath;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.IdleGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalInterruptedException;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;

public class FollowPathGoal
extends Goal {
    public static final float WAYPOINT_TOLERANCE = 0.5f;
    public static final float DESTINATION_TOLERANCE = 0.15f;
    private final GraphPath<Vector2> pathToFollow;
    private final TiledMap map;
    private int pathCursor = 0;

    public FollowPathGoal(Entity parentEntity, Goal parentGoal, GraphPath<Vector2> path, TiledMap map) {
        super(parentEntity, parentGoal);
        this.pathToFollow = path;
        this.map = map;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        SteeringComponent steeringComponent = this.parentEntity.getBehaviourComponent().getSteeringComponent();
        LocationComponent locationComponent = this.parentEntity.getLocationComponent();
        Vector2 destination = this.pathToFollow.get(this.pathToFollow.getCount() - 1);
        Vector2 nextPathNode = this.pathToFollow.get(this.pathCursor);
        steeringComponent.setDestination(destination);
        steeringComponent.setNextWaypoint(nextPathNode);
        MapTile nextTile = this.map.getTile(nextPathNode);
        if (!nextTile.isNavigable()) {
            throw new GoalInterruptedException("Path is no longer navigable");
        }
        if (Math.abs(locationComponent.getWorldPosition().x - nextPathNode.x) < 0.5f && Math.abs(locationComponent.getWorldPosition().y - nextPathNode.y) < 0.5f && this.pathCursor + 1 < this.pathToFollow.getCount()) {
            ++this.pathCursor;
        }
    }

    @Override
    public boolean isComplete() {
        boolean arrivedAtDestination;
        Vector2 destination = this.pathToFollow.get(this.pathToFollow.getCount() - 1);
        Vector2 worldPosition = this.parentEntity.getLocationComponent().getWorldPosition();
        boolean bl = arrivedAtDestination = Math.abs(worldPosition.x - destination.x) < 0.15f && Math.abs(worldPosition.y - destination.y) < 0.15f;
        if (arrivedAtDestination) {
            this.parentEntity.getBehaviourComponent().getSteeringComponent().destinationReached();
            this.parentGoal.getChildGoals().addLast(new IdleGoal(this.parentEntity, 0.02f));
        }
        return arrivedAtDestination;
    }

    public GraphPath<Vector2> getPathToFollow() {
        return this.pathToFollow;
    }

    public int getPathCursor() {
        return this.pathCursor;
    }
}

